<?php
class clientesModel extends Db
{
    public $IdCliente;
    public $Nombre;
    public $RFC;
    public $FisTelefono;
    public $FisEmail;

    public $Persona;
    public $CFDI;
    public $RegimenFiscal;
    public $TipoPago;
    //Domicilio Fiscal
    public $FisCalle;
    public $FisNExt;
    public $FisNInt;
    public $FisColonia;
    public $FisCP;
    public $FisMunicipio;
    public $FisEstado;
    //Domicilio Entrega
    public $IdDomicilio;
    public $EntCalle;
    public $EntNExt;
    public $EntNInt;
    public $EntColonia;
    public $EntCP;
    public $EntMunicipio;
    public $EntEstado;
    public $EntGiro;
    public $EntDesde;
    public $EntHasta;
    public $EntCruces;
    public $EntObservaciones;

    public $activo;
    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function add()
    {
        $sql = "INSERT INTO clientes (Nombre, Clave, RFC, Persona, CFDI, RegimenFiscal, TipoPago, FisTelefono, FisEmail, FisCalle, FisNExt, FisNInt, FisColonia, FisCP, FisMunicipio, FisEstado, Activo) 
        VALUES (:Nombre, :Clave, :RFC, :Persona, :CFDI, :RegimenFiscal, :TipoPago, :FisTelefono, :FisEmail, :FisCalle, :FisNExt, :FisNInt, :FisColonia, :FisCP, :FisMunicipio, :FisEstado, :Activo)";
        $data =
            [
                'Nombre' => $this->Nombre,
                'Clave' => random_strings(8),
                'RFC' => $this->RFC,
                'Persona' => $this->Persona,
                'CFDI' => $this->CFDI,
                'RegimenFiscal' => $this->RegimenFiscal,
                'TipoPago' => $this->TipoPago,
                'FisTelefono' => $this->FisTelefono,
                'FisEmail' => $this->FisEmail,
                'FisCalle' => $this->FisCalle,
                'FisNExt' => $this->FisNExt,
                'FisNInt' => $this->FisNInt,
                'FisColonia' => $this->FisColonia,
                'FisCP' => $this->FisCP,
                'FisMunicipio' => $this->FisMunicipio,
                'FisEstado' => $this->FisEstado,
                'Activo' => 1,
            ];

        try {
            return ($this->IdCliente = parent::query($sql, $data)) ? $this->IdCliente : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function add_domicilio()
    {
        $sql = "INSERT INTO domentregacltes (IdCliente, EntCalle, EntNExt, EntNInt, EntColonia, EntCP, EntMunicipio, EntEstado, EntGiro, EntDesde, EntHasta, EntCruces, EntObservaciones) 
        VALUES (:IdCliente, :EntCalle, :EntNExt, :EntNInt, :EntColonia, :EntCP, :EntMunicipio, :EntEstado, :EntGiro, :EntDesde, :EntHasta, :EntCruces, :EntObservaciones)";
        $data =
            [
                'IdCliente' => $this->IdCliente,
                'EntCalle' => $this->EntCalle,
                'EntNExt' => $this->EntNExt,
                'EntNInt' => $this->EntNInt,
                'EntColonia' => $this->EntColonia,
                'EntCP' => $this->EntCP,
                'EntMunicipio' => $this->EntMunicipio,
                'EntEstado' => $this->EntEstado,
                'EntGiro' => $this->EntGiro,
                'EntDesde' => $this->EntDesde,
                'EntHasta' => $this->EntHasta,
                'EntCruces' => $this->EntCruces,
                'EntObservaciones' => $this->EntObservaciones,
            ];

        try {
            return ($this->IdDomicilio = parent::query($sql, $data)) ? $this->IdDomicilio : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all()
    {
        $sql = "SELECT c.IdCliente,c.Nombre,c.Clave,c.Clave, c.RFC, c.Persona, c.CFDI, c.RegimenFiscal, c.TipoPago, c.FisTelefono, c.FisEmail, c.FisCalle,c.FisNExt,c.FisNInt,
        c.FisColonia, c.FisCP, c.FisMunicipio, c.FisEstado, d.IdDomicilio, d.EntCalle, d.EntNExt, d.EntNInt, d.EntColonia, d.EntCP,
        d.EntMunicipio, d.EntEstado, d.EntGiro, d.EntDesde, d.EntHasta, d.EntCruces, d.EntObservaciones, g.Descripcion
         FROM clientes c LEFT JOIN domentregacltes d ON  d.IdCliente = c.IdCliente  LEFT JOIN giros g ON d.EntGiro = g.IdGiro 
         WHERE c.activo=1 AND d.NumDomicilio = 1 ORDER BY c.IdCliente";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function one()
    {
        $sql = "SELECT c.*, d.IdDomicilio, d.EntCalle, d.EntNExt, d.EntNInt, d.EntColonia, d.EntCP,
        d.EntMunicipio, d.EntEstado, d.EntGiro, d.EntDesde, d.EntHasta, d.EntCruces, d.EntObservaciones, g.Descripcion
         FROM clientes c LEFT JOIN domentregacltes d ON  d.IdCliente = c.IdCliente  LEFT JOIN giros g ON d.EntGiro = g.IdGiro 
         WHERE d.NumDomicilio = 1 AND c.IdCliente=:IdCliente LIMIT 1";
        try {
            return ($rows = parent::query($sql, ['IdCliente' => $this->IdCliente])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update()
    {
        $sql = "UPDATE clientes SET 
        Nombre=:Nombre, RFC=:RFC, Persona=:Persona, CFDI=:CFDI, RegimenFiscal=:RegimenFiscal, TipoPago=:TipoPago,  
        FisTelefono=:FisTelefono,FisEmail=:FisEmail, FisCalle=:FisCalle, FisNExt=:FisNExt, FisNInt=:FisNInt, 
        FisColonia=:FisColonia, FisCP=:FisCP, FisMunicipio=:FisMunicipio, FisEstado=:FisEstado
        WHERE IdCliente=:IdCliente";
        $data =
            [
                'Nombre' => $this->Nombre,
                'RFC' => $this->RFC,
                'Persona' => $this->Persona,
                'CFDI' => $this->CFDI,
                'RegimenFiscal' => $this->RegimenFiscal,
                'TipoPago' => $this->TipoPago,
                'FisTelefono' => $this->FisTelefono,
                'FisEmail' => $this->FisEmail,
                'FisCalle' => $this->FisCalle,
                'FisNExt' => $this->FisNExt,
                'FisNInt' => $this->FisNInt,
                'FisColonia' => $this->FisColonia,
                'FisCP' => $this->FisCP,
                'FisMunicipio' => $this->FisMunicipio,
                'FisEstado' => $this->FisEstado,
                'IdCliente' => $this->IdCliente,
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function update_domicilio()
    {
        $sql = "UPDATE domentregacltes SET 
        EntCalle=:EntCalle, EntNExt=:EntNExt, EntNInt=:EntNInt, 
        EntColonia=:EntColonia, EntCP=:EntCP, EntMunicipio=:EntMunicipio, EntEstado=:EntEstado, 
        EntGiro=:EntGiro, EntDesde=:EntDesde, EntHasta=:EntHasta, EntCruces=:EntCruces,EntObservaciones=:EntObservaciones
        WHERE IdDomicilio=:IdDomicilio";
        $data =
            [
                'EntCalle' => $this->EntCalle,
                'EntNExt' => $this->EntNExt,
                'EntNInt' => $this->EntNInt,
                'EntColonia' => $this->EntColonia,
                'EntCP' => $this->EntCP,
                'EntMunicipio' => $this->EntMunicipio,
                'EntEstado' => $this->EntEstado,
                'EntGiro' => $this->EntGiro,
                'EntDesde' => $this->EntDesde,
                'EntHasta' => $this->EntHasta,
                'EntCruces' => $this->EntCruces,
                'EntObservaciones' => $this->EntObservaciones,
                'IdDomicilio' => $this->IdDomicilio,
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function delete()
    {

        $sql = "UPDATE clientes SET Activo=:activo WHERE IdCliente=:IdCliente";
        $data =
            [
                'activo' => $this->activo,
                'IdCliente' => $this->IdCliente
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
}
